package org.simantics.team.internal;

import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.simantics.team.Activator;

public class Images {

    private LocalResourceManager rm;
    private static Images INSTANCE;

    private Images(ResourceManager manager) {
        this.rm = new LocalResourceManager(manager);

        CHANGE_SET_IMAGE = manager.createImage(Activator.CHANGE_SET_ICON);
        DISPLAY_IMAGE = manager.createImage(Activator.DISPLAY_ICON);
        RESOURCE_IMAGE = manager.createImage(Activator.RESOURCE_ICON);
        STRING_IMAGE = manager.createImage(Activator.STRING_ICON);
        COMBINED_IMAGE = manager.createImage(Activator.COMBINED_ICON);
        UNDO_IMAGE = manager.createImage(Activator.UNDO_ICON);
        REDO_IMAGE = manager.createImage(Activator.REDO_ICON);
        OTHER_IMAGE = manager.createImage(Activator.OTHER_ICON);
        DEBUG_IMAGE = manager.createImage(Activator.DEBUG_ICON);
        EXIT_IMAGE = manager.createImage(Activator.EXIT_ICON);
    }

    public void dispose() {
        rm.dispose();
        rm = null;

        CHANGE_SET_IMAGE = null;
        DISPLAY_IMAGE = null;
        RESOURCE_IMAGE = null;
        STRING_IMAGE = null;
        COMBINED_IMAGE = null;
        UNDO_IMAGE = null;
        REDO_IMAGE = null;
        OTHER_IMAGE = null;
        DEBUG_IMAGE = null;
        EXIT_IMAGE = null;
    }

    public static Images getInstance(ResourceManager rm) {
        if (INSTANCE == null) {
            INSTANCE = new Images(rm);
        }
        return INSTANCE;
    }

    public static Images getInstance() {
        if (INSTANCE == null)
            throw new IllegalStateException("Images not initialized");
        return INSTANCE;
    }
    
    public static void disposeInstance() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    public Image CHANGE_SET_IMAGE;
    public Image DISPLAY_IMAGE;
    public Image RESOURCE_IMAGE;
    public Image STRING_IMAGE;
    public Image COMBINED_IMAGE;
    public Image UNDO_IMAGE;
    public Image REDO_IMAGE;
    public Image OTHER_IMAGE;
    public Image DEBUG_IMAGE;
    public Image EXIT_IMAGE;

}
