package org.simantics.team;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.ui.Preferences;

public class Utils {
    public static final File getNewFolder(int index, String prefix, String suffix) {
        File toFolder;
        do {
            toFolder = new File(prefix + index + suffix);
        } while (toFolder.exists());
        return toFolder;
    }
    private static final Charset ASCII = Charset.forName("US-ASCII");
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String bytesToStringASCII(byte[] bytes, int offset, int length)
    throws IOException {
        return bytesToString(bytes, offset, length, ASCII);
    }
    public static final String bytesToStringUTF8(byte[] bytes, int offset, int length)
    throws IOException {
        return bytesToString(bytes, offset, length, UTF8);
    }
    public static final String bytesToString(byte[] bytes, int offset, int length, Charset charset)
    throws IOException {
        if (bytes == null || offset < 0 || offset > length - 1 || length < 0 || length > bytes.length)
            return null;
        ByteBuffer bbuf = ByteBuffer.wrap(bytes, offset, length);
        CharBuffer cbuf;
        String s = null;
        try {
            cbuf =  charset.newDecoder().decode(bbuf);
            s = cbuf.toString();
        } catch (CharacterCodingException e) {
            bbuf.rewind();
            try {
                cbuf = charset.newDecoder()
                .onMalformedInput(CodingErrorAction.REPLACE)
                .onUnmappableCharacter(CodingErrorAction.REPLACE)
                .decode(bbuf);
                s = cbuf.toString();
            } catch (CharacterCodingException e1) {
                throw new IOException("String conversion error.", e1);
            }
        }
        return s;
    }
    public static final File getTeamFolder() 
    throws DatabaseException {
        IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.PLUGIN_ID);
        String currentTeamFolder = store.getString(Preferences.CURRENT_TEAM_FOLDER);
        if (!currentTeamFolder.equals(""))
            return new File(currentTeamFolder);
        String name = System.getProperty("staging.team.folder");
        if (null != name && !name.equals(""))
            return new File(name);
        String folder = System.getProperty("java.io.tmpdir");
        if (null == folder || folder.equals(""))
            throw new DatabaseException("Could not get team folder path.");
        return null;
//        IProduct product = Platform.getProduct();
//        if (null != product)
//            name = "Team " + product.getName();
//        else
//          name = "Default Team Folder";
//        return new File(folder, name);
    }
    public static final void setTeamFolder(File teamFolder) 
    throws DatabaseException {
        IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.PLUGIN_ID);
        if (null == teamFolder)
            store.setValue(Preferences.CURRENT_TEAM_FOLDER, "");
        else
            store.setValue(Preferences.CURRENT_TEAM_FOLDER, teamFolder.getAbsolutePath());
    }
}
