/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.variables;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.Functions;
import org.simantics.structural2.variables.AbstractVariableConnectionPointDescriptor;
import org.simantics.structural2.variables.ConnectionBrowser;

class ActualConnectionDescriptor
extends AbstractVariableConnectionPointDescriptor {
    private final Variable root;
    private final Resource component;
    private final Resource cp;

    public ActualConnectionDescriptor(Variable root, Resource component, Resource cp) {
        this.root = root;
        this.component = component;
        this.cp = cp;
    }

    @Override
    public Collection<Functions.InterfaceResolution> getInterfaceDescription(ReadGraph graph) throws DatabaseException {
        return (Collection)graph.syncRequest((Read)new ComputeInterfaceDescription(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public Resource getConnectionPointResource(ReadGraph graph) throws DatabaseException {
        return this.cp;
    }

    @Override
    public Variable getVariable(ReadGraph graph) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ComputeVariable(this), (AsyncProcedure)TransientCacheAsyncListener.instance());
    }

    @Override
    public String getURI(ReadGraph graph) throws DatabaseException {
        Variable var = this.getVariable(graph);
        return var.getURI(graph);
    }

    @Override
    public boolean isFlattenedFrom(ReadGraph graph, Variable possiblyStructuralCp) throws DatabaseException {
        Resource otherCp = possiblyStructuralCp.getPossiblePredicateResource(graph);
        if (!this.cp.equals(otherCp)) {
            return false;
        }
        Variable otherComponentVariable = possiblyStructuralCp.getParent(graph);
        Resource otherComponent = otherComponentVariable.getPossibleRepresents(graph);
        if (!this.component.equals(otherComponent)) {
            return false;
        }
        Variable otherContainer = otherComponentVariable.getParent(graph);
        if (otherContainer.equals(this.root)) {
            return true;
        }
        return this.getVariable(graph).equals(possiblyStructuralCp);
    }

    @Override
    public String getRelativeRVI(ReadGraph graph, Variable base) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String cpName = (String)graph.getRelatedValue(this.cp, L0.HasName, (Binding)Bindings.STRING);
        if (cpName.startsWith("/")) {
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            if (graph.isInstanceOf(this.component, MOD.ReferenceElement)) {
                return "#" + cpName;
            }
        }
        if (this.root.equals(base.getParent(graph))) {
            StringBuilder b = new StringBuilder();
            b.append("./");
            String cName = (String)graph.getRelatedValue(this.component, L0.HasName, (Binding)Bindings.STRING);
            b.append(URIStringUtils.escape((String)cName));
            b.append("#");
            b.append(cpName);
            return b.toString();
        }
        return super.getRelativeRVI(graph, base);
    }

    static class ComputeInterfaceDescription
    extends UnaryRead<ActualConnectionDescriptor, Collection<Functions.InterfaceResolution>> {
        public ComputeInterfaceDescription(ActualConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Collection<Functions.InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource type = graph.getPossibleType(((ActualConnectionDescriptor)this.parameter).component, STR.Component);
            if (((Boolean)graph.syncRequest((Read)new ConnectionBrowser.IsLeafType(type))).booleanValue()) {
                return null;
            }
            return Functions.computeInterfacePaths(graph, ((ActualConnectionDescriptor)this.parameter).getVariable(graph).getParent(graph));
        }
    }

    static class ComputeVariable
    extends UnaryRead<ActualConnectionDescriptor, Variable> {
        public ComputeVariable(ActualConnectionDescriptor desc) {
            super((Object)desc);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            Variable cnp;
            Variable c = ConnectionBrowser.resolve(graph, ((ActualConnectionDescriptor)this.parameter).root, ((ActualConnectionDescriptor)this.parameter).component);
            if (c != null && (cnp = c.getPossibleProperty(graph, ((ActualConnectionDescriptor)this.parameter).cp)) != null) {
                return cnp;
            }
            throw new DatabaseException("Unresolved connection point (root=" + ((ActualConnectionDescriptor)this.parameter).root.getURI(graph) + ", component=" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)((ActualConnectionDescriptor)this.parameter).component) + ", cp=" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)((ActualConnectionDescriptor)this.parameter).cp) + ")");
        }
    }
}

