/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.queries;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.TransientResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.structural2.queries.PossibleConnectionPointInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPointMapOfResource
extends TransientResourceRead<Map<String, Resource>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPointMapOfResource.class);

    public ConnectionPointMapOfResource(ReadGraph graph, Resource resource) throws DatabaseException {
        super(graph, resource);
    }

    public ConnectionPointMapOfResource(ReadGraph graph, QueryControl qc, Resource resource) throws DatabaseException {
        super(graph, qc, resource);
    }

    public Map<String, Resource> perform(ReadGraph graph, Resource resource) throws DatabaseException {
        Collection predicates = graph.getPredicates(resource);
        THashMap result = null;
        for (Resource predicate : predicates) {
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PossibleConnectionPointInfo(predicate), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (info == null) continue;
            if (result == null) {
                result = new THashMap(predicates.size());
            }
            if (result.put((Object)info.name, (Object)predicate) == null) continue;
            LOGGER.error("The database contains siblings with the same name " + info.name + " (resource=$" + resource.getResourceId() + ").");
        }
        if (result != null) {
            return result;
        }
        return Collections.emptyMap();
    }

    public int getType() {
        return 0;
    }
}

