package org.simantics.spreadsheet.ui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableName;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.request.VariableRepresents;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.spreadsheet.graph.GraphUI;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.ResourceEditorPart2;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SpreadsheetEditor2 extends ResourceEditorPart2 {

    public static final boolean EXCEL = false;
    public static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor2";

    private Spreadsheet spreadsheet;
    private final ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    private ExcelLink excelLink;
    private GraphUI ui;

    public Spreadsheet getSpreadsheet() {
        return spreadsheet;
    }

    @Override
    public void createPartControl(Composite parent) {

        // Create UI
        parent.setLayout(LayoutUtils.createNoBorderGridLayout(1));
        parent.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_WHITE));

        ui = new GraphUI(getSession());

        try {
        	
            Variable bookVariable = getSession().syncRequest(new Read<Variable>() {

                @Override
                public Variable perform(ReadGraph graph) throws DatabaseException {
                	
                	Resource book = getResourceInput2().getResource();
                	Variable withContext = SpreadsheetUtils.getBookVariable(graph, book); 
                	return withContext; 

                }

            });
            
//            getSession().syncRequest(new VariableRead<Variable>(bookVariable) {
//
//                @Override
//                public Variable perform(ReadGraph graph) throws DatabaseException {
//                    SpreadsheetGraphUtils.fullSynchronization(graph, variable);
//                    return variable;
//                }
//
//            });
            
            Variable sheetVariable = getSession().syncRequest(new VariableRead<Variable>(bookVariable) {

                @Override
                public Variable perform(ReadGraph graph) throws DatabaseException {
                	
                	SpreadsheetResource SR = SpreadsheetResource.getInstance(graph);
                	Collection<Variable> children = variable.getChildren(graph);
                	if(children.isEmpty()) return null;
                	
                	TreeMap<String,Variable> names = new TreeMap<String,Variable>();
                	for(Variable child : children) {
                		Resource type = child.getPossibleType(graph, SR.Spreadsheet);
                		if(type != null)
                			names.put(child.getName(graph), child);
                	}
                	
                	return names.firstEntry().getValue();

                }

            });
            
            String uri = getSession().syncRequest(new VariableURI(sheetVariable));
            
            Resource book = getSession().syncRequest(new VariableRepresents(bookVariable));
            Resource sheet = getSession().syncRequest(new VariableRepresents(sheetVariable));
            String sheetName = getSession().syncRequest(new VariableName(sheetVariable));
            String bookName = getSession().syncRequest(new VariableName(bookVariable));

            spreadsheet = new Spreadsheet(parent, SWT.NONE, ui, selectionProvider);
	        spreadsheet.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_WHITE));
	
	        excelLink = new ExcelLink(getSession(), sheet, spreadsheet.getClientModel(), book, bookName, sheetName, uri);

	        if (GraphUI.DEBUG)
	            System.out.println("Opening SpreadsheetEditor2 with uri: " + uri);
            ui.load(sheetVariable, spreadsheet.getClientInterface());
            
        } catch (DatabaseException e) {
        	
            e.printStackTrace();
        	return;
        	
        }

        spreadsheet.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        spreadsheet.defaultInitializeUI();

        getSite().setSelectionProvider(selectionProvider);

        // Start tracking editor input validity. 
        activateValidation();
        
        IContextService contexts = (IContextService)getSite().getService(IContextService.class);
        contexts.activateContext("org.simantics.spreadsheet.ui.context");

    }

    @Override
    public void setFocus() {
        if (spreadsheet != null)
            spreadsheet.setFocus();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertyPage.class)
            return new StandardPropertyPage(getSite(), Collections.singleton(SpreadsheetResource.URIs.BrowseContext));
        if (adapter == GraphUI.class)
            return ui;
        if (adapter == Spreadsheet.class)
            return getSpreadsheet();
        return null;
    }

    @Override
    public void dispose() {

        if(EXCEL)
            excelLink.dispose();
        
//        backend.dispose();

//        tableModel.dispose();
        ui.dispose();
        super.dispose();

    }

}