/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui.editor;

import java.util.Collections;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.spreadsheet.graph.GraphUI;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.ResourceEditorPart2;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SpreadsheetEditor extends ResourceEditorPart2 {

    public static final boolean EXCEL = true;
    public static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor";

    private Spreadsheet spreadsheet;
//    private SimpleContainerTableModel tableModel;
    private final ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    //private ExcelLink excelLink;
    private GraphUI ui;

    public Spreadsheet getSpreadsheet() {
        return spreadsheet;
    }

    @Override
    public void createPartControl(Composite parent) {

        // Create UI
        parent.setLayout(LayoutUtils.createNoBorderGridLayout(1));
        parent.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_WHITE));

        ui = new GraphUI(getSession());

        try {

        	Variable variable = getSession().syncRequest(new Read<Variable>() {

        		@Override
        		public Variable perform(ReadGraph graph) throws DatabaseException {
        			
//                    String modelURI = getResourceInput2().getModelURI();
//                    String rvi = getResourceInput2().getRVI();
//                    Resource model = graph.getResource(modelURI);
//					Resource config = getInputResource();
////					String configName = URIStringUtils.escape((String)graph.getPossibleRelatedValue(config, b.HasName, Bindings.STRING));
////					Resource model = StructuralVariables.getModel(graph, config);
//                    Resource realization = graph.getPossibleObject(model, b.HasBaseRealization);
//                    Variable base = graph.adapt(realization, Variable.class);
//                    return base.browse(graph, rvi);
                    return null;
        			
        		}

        	});

        	spreadsheet = new Spreadsheet(parent, SWT.NONE, ui, selectionProvider);
        	spreadsheet.setBackground(parent.getDisplay().getSystemColor(SWT.COLOR_WHITE));

            ui.load(variable, spreadsheet.getClientInterface());
        } catch (DatabaseException e) {
            e.printStackTrace();
        }

        spreadsheet.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        spreadsheet.defaultInitializeUI();

        getSite().setSelectionProvider(selectionProvider);

        IContextService contexts = (IContextService)getSite().getService(IContextService.class);
        contexts.activateContext("org.simantics.spreadsheet.ui.context");

    }

    @Override
    public void setFocus() {
        if (spreadsheet != null)
            spreadsheet.setFocus();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertyPage.class)
            return new StandardPropertyPage(getSite(), Collections.singleton(SpreadsheetResource.URIs.BrowseContext));
        if (adapter == GraphUI.class)
            return ui;
        if (adapter == Spreadsheet.class)
            return getSpreadsheet();
        return null;
    }

    @Override
    public void dispose() {

//        if(EXCEL)
//            excelLink.dispose();
        
//        backend.dispose();

//        tableModel.dispose();

        super.dispose();

    }

}
