/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui.editor;

import java.io.File;
import java.io.IOException;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.excel.Excel;
import org.simantics.excel.ExcelException;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.common.client.ClientModelListenerAdapter;
import org.simantics.spreadsheet.common.exception.CellParseException;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class ExcelLink extends ClientModelListenerAdapter {

	final private Session session;
	final private Resource container;
    final private ClientModel model;
    final private Resource book;
    final private String bookName;
    final private String sheetName;
    final private String prefix;
    final private Excel excel;
    private int handle;
    
    public ExcelLink(Session session, Resource container, ClientModel model, final Resource book, String bookName, String sheetName, String prefix) {
        
    	this.session = session;
    	this.container = container;
    	this.handle = 0;
        this.model = model;
        this.bookName = bookName + ".xlsx";
        this.sheetName = sheetName;
        this.prefix = prefix;
        this.book = book;
        
        this.excel = tryGetExcel(book, bookName);

		model.addListener(this);
        
    }
    
    public static Excel tryGetExcel(final Resource book, final String bookName) {

    	try {

    		Excel excel = Excel.getInstance(System.out);
    		String file = excel.getFile(bookName);
    		final File tester = new File(file);

    		if(!tester.exists()) {
    			// Restore file from graph
    			try {
    				byte[] saved = Simantics.getSession().syncRequest(new ResourceRead<byte[]>(book) {

    					@Override
    					public byte[] perform(ReadGraph graph) throws DatabaseException {
    						SpreadsheetResource SR = SpreadsheetResource.getInstance(graph);
    						return graph.getPossibleRelatedValue(book, SR.HasMicrosoftExcelDocumentData, Bindings.BYTE_ARRAY);
    					}

    				});
    				if(saved != null) FileUtils.writeFile(tester, saved);
    			} catch (DatabaseException e) {
    				Logger.defaultLogError(e);
    			} catch (IOException e) {
    				Logger.defaultLogError(e);
    			}
    		}

    		return excel;

    	} catch (ExcelException e1) {

    		Logger.defaultLogError(e1);

    	} 

    	return null;

    }

    public void dispose() {
    	
    	model.removeListener(this);

		try {
			
			if(excel != null) {
		    	if(handle != 0) excel.close_(handle);
				String file = excel.getFile(bookName);
				File tester = new File(file);
				if(tester.exists()) {
					final byte[] saved = FileUtils.readFile(tester);
					if(saved != null) {
						Simantics.getSession().syncRequest(new WriteRequest() {
	
							@Override
							public void perform(WriteGraph graph) throws DatabaseException {
								SpreadsheetResource SR = SpreadsheetResource.getInstance(graph);
								graph.claimLiteral(book, SR.HasMicrosoftExcelDocumentData, saved, Bindings.BYTE_ARRAY);
							}
	
						});
					}
				}
			}
			
		} catch (DatabaseException e) {
			Logger.defaultLogError(e);
		} catch (IOException e) {
			Logger.defaultLogError(e);
		}
    	
    }

	@Override
	public void propertyChange(String location, String property, Object value) {
		
		if(ClientModel.CONTENT.equals(property) && value != null && value instanceof Variant) {
			
			if(handle == 0) return;
			Range range = SpreadsheetUtils.decodeCellAbsolute(location);
			excel.setString_(handle, range.startRow, range.startColumn, ((Variant)value).getValue().toString());
			final String modis = excel.getModifications_(handle);

			session.asyncRequest(new WriteRequest() {

				@Override
				public void perform(WriteGraph graph) throws DatabaseException {

					String[] parts = (modis+"0").split("#");
					
					Range range = SpreadsheetUtils.decodeRange(parts[0]);
					
	    			Layer0 L0 = Layer0.getInstance(graph);
	    			SpreadsheetResource SHEET = SpreadsheetResource.getInstance(graph);
					
					int index = 1;
					for(int i=0;i<range.height();i++) {
						for(int j=0;j<range.width();j++) {
							
							String addr = SpreadsheetUtils.cellName(range.startRow + i, range.startColumn + j);
							String content = parts[index++];
							
							Resource cell = Layer0Utils.getPossibleChild(graph, container, addr);
							if(cell != null) {
								Variant newValue = Variant.ofInstance(content);
								Variant existing = graph.getRelatedValue(cell, SHEET.Cell_content, Bindings.VARIANT);
								if(!newValue.equals(existing)) {
									graph.claimLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, newValue, Bindings.VARIANT);
								}
							} else {
								cell = graph.newResource();
								graph.claim(cell, L0.InstanceOf, null, SHEET.TextCell);
								graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, addr, Bindings.STRING);
								graph.addLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, Variant.ofInstance(content), Bindings.VARIANT);
								graph.claim(cell, L0.PartOf, container);
							}
							
						}
					}
					
					for(int i=1;i<parts.length;i++) {
//						String addr = parts[i];
//						String content = parts[i+1];
//						
//		    			Layer0 L0 = Layer0.getInstance(graph);
//		    			SpreadsheetResource SHEET = SpreadsheetResource.getInstance(graph);
//		    			
//		    			Resource cell = Layer0Utils.getPossibleChild(graph, container, addr);
//		    			if(cell != null) {
//		    				Variant newValue = Variant.ofInstance(content);
//		    				Variant existing = graph.getRelatedValue(cell, SHEET.Cell_content, Bindings.VARIANT);
//		    				if(!newValue.equals(existing))
//		    					graph.claimLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, newValue, Bindings.VARIANT);
//		    			} else {
//			    			cell = graph.newResource();
//			    			graph.claim(cell, L0.InstanceOf, null, SHEET.TextCell);
//			    			graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, addr, Bindings.STRING);
//			    			graph.addLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, Variant.ofInstance(content), Bindings.VARIANT);
//			    			graph.claim(cell, L0.PartOf, container);
//		    			}
		    			

					}
					
					
				}
				
			});
			
//			System.err.println("excel.setString " + value);
			
		} else if("Excel".equals(location) && "Visible".equals(property) && value instanceof Boolean) {

			Boolean visible = (Boolean)value;
			if(visible) {
				
		        try {
		        	if(handle == 0) {
		        		
		        		Excel excel = Excel.getInstance(System.out);
		        		String file = excel.getFile(bookName);
		        		FileUtils.ensureParentDirectoryExists(file);
		        		
		        		//String sheetName2 = sheetName;//(sheetName + UUID.randomUUID().toString()).substring(0,30);
		        		String sheetName2 = (bookName + "_" + sheetName).substring(0,30).replace(".", "_");
		        		
		        		String handleString = excel.open_(file, sheetName2);
		        		try {
		        			handle = Integer.valueOf(handleString);
		        		} catch (NumberFormatException e) {
		        			ShowMessage.showError("Problems with Excel", handleString);
		        			Logger.defaultLogError(new RuntimeException(handleString));
		        			return;
		        		}
//				        System.err.println("excel.open " + (name + ".xlsx"));
				        
						for(Pair<String, Object> label : model.listAll(ClientModel.LABEL)) {
							try {
								Range range = SpreadsheetUtils.decodeCellAbsolute(label.first);
								excel.setString_(handle, range.startRow, range.startColumn, (String)label.second);
//								System.err.println("excel.setString " + label.second);
							} catch (CellParseException e) {
							}
						}
						for(Pair<String, Object> label : model.listAll(ClientModel.CONTENT)) {
							try {
								Range range = SpreadsheetUtils.decodeCellAbsolute(label.first);
								//excel.setString_(handle, range.startRow, range.startColumn, (String)label.second);
								
								String uri = (String)label.second;
								if(uri.startsWith(prefix)) {
									String rvi = uri.substring(prefix.length()+1).replace("#", "_").replace("(", "_").replace(")", "_").replace("+", "p").replace("-", "m");
									excel.setName_(handle, range.startRow, range.startColumn, rvi);
//									System.err.println("excel.setCellName '" + rvi + "'");
								}
								
							} catch (CellParseException e) {
							}
						}
						
		        	}
		        } catch (Throwable t) {
		        	Logger.defaultLogError(t);
		        }
				
			} else {

		        try {
//		        	doClose();
		        	if(handle != 0) {
		        		Excel excel = Excel.getInstance(System.out); 
		        		handle = excel.close_(handle);
		        		handle = 0;
		        	}
		        } catch (Throwable t) {
		        	Logger.defaultLogError(t);
		        }
				
			}
//			excel.setVisible_(handle, (Boolean)value);
//			System.err.println("excel.setVisible " + value);
		}
	}
    
//    @Override
//    public void changed(int row, int column, Cell cell) {
//
//        String value = cell != null ? cell.toString() : "";
//        if(value == null) value = "...";
//        excel.setString_(handle, row, column, value);
//        
//    }

}
