/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.participant.PopulateSelectionDropParticipant;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.element.ElementHints;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.ui.ISelectionUtils;

public class PopulateSheetDropParticipant extends PopulateSelectionDropParticipant {

    public PopulateSheetDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        super(synchronizer);
    }

    @Override
    public List<ElementClassDragItem> getElements(Session session, IStructuredSelection selection) throws DatabaseException {

        final Resource resource = ISelectionUtils.filterSingleSelection(selection, Resource.class);
        if(resource == null) return Collections.emptyList();

        return session.syncRequest(new Read<List<ElementClassDragItem>>() {

            @Override
            public List<ElementClassDragItem> perform(ReadGraph graph) throws DatabaseException {

                SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
                if(graph.isInstanceOf(resource, sr.Spreadsheet)) {
                    Layer0 L0 = Layer0.getInstance(graph);
                    ElementClassDragItem item = new ElementClassDragItem(SheetFactory.createSheetClass(sr.SpreadsheetElement));
                    item.getHintContext().setHint(SheetClass.KEY_SHEET, resource);
                    String rvi = "/" + URIStringUtils.escape((String)graph.getPossibleRelatedValue(resource, L0.HasName, Bindings.STRING));
                    item.getHintContext().setHint(SheetClass.KEY_RVI, rvi);
                    item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, AffineTransform.getScaleInstance(1,1));
                    return Collections.singletonList(item);
                } else {
                    return Collections.emptyList();
                }

            }

        });

    }

}