package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.Font;

import javax.swing.border.Border;

public class CellValue {
    
    public boolean editable = false;
    
	public String label;
	public int border;
	public int align;
	public Font font;
	public Color foreground;
	public Color background;
	public CellValue(String label, Font font, Color foreground, Color background, int border, int align, boolean editable) {
	    this.editable = editable;
		this.label = label;
		this.font = font;
		this.foreground = foreground;
		
		if (editable) {
		    this.background = background;
		} else {
		    this.background = new Color(220, 220, 220, 100);
		}
		this.border = border;
		this.align = align;
	}
	
	final SheetBorder BORDER0 = new SheetBorder(1,1,1,1,false, false); 
	final SheetBorder BORDER1 = new SheetBorder(1,1,1,1,false, true); 
	final SheetBorder BORDER2 = new SheetBorder(1,1,1,1,true, false); 
	final SheetBorder BORDER3 = new SheetBorder(1,1,1,1,true, true);
	
	/*
	 * 1 = right
	 * 2 = bottom
	 */
	public Border getBorder() {
		switch(border) {
		case 0: return BORDER0;
		case 1: return BORDER1;
		case 2: return BORDER2;
		case 3: return BORDER3;
		}
		return BORDER0;
	}
	
}
