/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet;

import java.util.List;
import java.util.function.Consumer;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.ClientModel.OperationMode;

public interface CellEditor<O> {
    
	public interface Transaction<O> {
	    
	    void setContext(Object context);
	    
	    Object getContext();
	    
	    void add(O operation);
	    
		/*
		 * Applies the operations collected with this transaction
		 * 
		 */
	    void commit();
	    
	    boolean isOperationMode();
        
        List<Object> needSynchronization();

        void needSynchronization(Object synchronizable);
	}
	
	/*
	 * Sets the given property of the given cell
	 * 
	 * @param transaction a combined transaction, null for immediate change
	 * @param location a cell location e.g. 'A1'
	 * @param property the name of the property
	 * @param value the property value
	 * @param binding used for serializing the value 
	 */
	<T> void edit(Transaction<O> transaction, String location, String property, T value, Binding binding, Consumer<?> callback);
	/*
	 * Edits the given cell using the given textual input
	 * 
	 * @param transaction a combined transaction, null for immediate change
	 * @param location a cell location e.g. 'A1'
	 * @param value a text describing the change
	 */
    void edit(Transaction<O> transaction, String location, Variant variant, Consumer<?> callback);

    void copy(Transaction<O> transaction, String location, MutableVariant variant, Consumer<?> callback);
    
	/*
	 * Creates a new transaction object
	 * 
	 */
    Transaction<O> startTransaction(OperationMode mode);
    
}
