package org.simantics.spreadsheet.common.cell;

import java.util.Collection;
import java.util.Collections;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.PropertyCreationData;
import org.simantics.scl.reflection.OntologyVersions;

public class TextStringCellParser implements StringCellParser {

	final static String TYPE = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Spreadsheet-0.0/TextCell"); 
	
    @Override
    public Collection<PropertyCreationData> parse(String text) {
        return Collections.singletonList(PropertyCreationData.build(Parsers.CONTENT_PROPERTY, Variant.ofInstance(text)));
    }
    
    @Override
    public String getType() { 
    	return TYPE;
    }
    
}