package org.simantics.spreadsheet.common.cell;

import java.util.Collection;
import java.util.Collections;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.VariableSpaceManipulator.PropertyCreationData;

public class ExpressionStringCellParser implements StringCellParser {

    @Override
    public Collection<PropertyCreationData> parse(String text) {
        if(text.startsWith("=")) {
            return Collections.singletonList(PropertyCreationData.build(Parsers.EXPRESSION_PROPERTY, Variant.ofInstance(text.replace("=", ""))));
        } else {
            return null;
        }
    }

    @Override
    public String getType() { 
    	return null;
    }
    
}