/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.layer0.bindings.ResourceBinding;

/**
 * This class creates bindings for Resource-interface, and Variable-interface.<<
 *   
 * @author toni.kalajainen
 */
public class SimanticsBindings implements BindingProvider {
	
	ResourceBinding resourceBinding;
	//VariableBinding variableBinding;
	
	public SimanticsBindings(Session session) {
		this.resourceBinding = new ResourceBinding((Session) null);
		//this.variableBinding = new VariableBinding(session);		
	}
	
	public Binding provideBinding(ClassBindingFactory master, BindingRequest request) throws BindingConstructionException {
		if (Resource.class.isAssignableFrom( request.getClazz() )) {
			return resourceBinding;
		}
		
		// Tuukka: disabled because the implementation is deadlock prone
		// and therefore Variables should not be used directly in Bean classes
		// until we figure out a way to fix VariableBinding or just throw it away.
//		if (Variable.class.isAssignableFrom( request.getClazz() )) {
//			return variableBinding;
//		}
		
		return null;
	}	

}
