/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.db.AbstractImportAdvisor2;
import org.simantics.graph.db.TransferableGraphImporter;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;

public class OntologyImportAdvisor extends AbstractImportAdvisor2 {

	final private GraphBundle tg;
	final private DatabaseManagement mgmt;
	final private String rootName;
	private Resource ontology;
	private Resource ontologyName;
	
	public OntologyImportAdvisor(GraphBundle tg, DatabaseManagement mgmt) {
	    this.tg = tg;
	    this.mgmt = mgmt;
	    if(tg.getName().contains("@")) {
		    rootName = tg.getName().substring(tg.getName().lastIndexOf("/")+1);
	    } else {
		    rootName = tg.getName().substring(tg.getName().lastIndexOf("/")+1) + "-" + tg.getMajor() + "." + tg.getMinor();
	    }
	}
	
	@Override
	public Resource getTarget() {
		return null;
	}
	
	@Override
	public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
		return null;
	}
	
	@Override
	public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
		return createRoot(graph, root, null); 
	}

	@Override
	public Resource createRoot(WriteOnlyGraph graph, Root root, Resource resource) throws DatabaseException {
		if(resource == null) resource = graph.newResource();
		addRootInfo(root, root.name, resource);
		return resource;
	}

    @Override
    public void beforeWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        ontology = graph.newResource(graph.getRootLibrary());
        ontologyName = graph.newResource(graph.getRootLibrary());
        graph.newClusterSet(ontology);
        graph.setClusterSet4NewResource(ontology);
    }

    @Override
    public void afterWrite(WriteOnlyGraph graph, TransferableGraphImporter process) throws DatabaseException {
        
        try {
            long[] ids = process.getResourceIds(graph.getService(SerialisationSupport.class));
            tg.setResourceArray(ids);
            mgmt.createGraphBundle(graph, tg);
            //graph.flushCluster();
        } catch (DatabaseException e) {
            throw new RuntimeDatabaseException(e);
        }
        
    }

    @Override
    public boolean allowImmutableModifications() {
        return true;
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent,
            String name) throws DatabaseException {
        if(rootName.equals(name)) {
        	
        	Layer0 L0 = graph.getService(Layer0.class);
    		graph.claim(ontologyName, L0.InstanceOf, null, L0.String);
    		graph.claimValue(ontologyName, name, WriteBindings.STRING);
    		graph.claim(ontology, L0.HasName, L0.NameOf, ontologyName);
    		return ontology;

        } else {
        	
            return process.createChild(graph, parent, null, name);
            
        }
    }

    @Override
    public Resource createChild(WriteOnlyGraph graph, TransferableGraphImporter process, Resource parent, Resource child,
            String name) throws DatabaseException {

    	if(rootName.equals(name)) {
        	
        	Layer0 L0 = graph.getService(Layer0.class);
    		graph.claim(ontologyName, L0.InstanceOf, null, L0.String);
    		graph.claimValue(ontologyName, name, WriteBindings.STRING);
    		graph.claim(ontology, L0.HasName, L0.NameOf, ontologyName);
    		return ontology;
        	
        } else {
        	
            return process.createChild(graph, parent, null, name);
            
        }
    }
    
}
