/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/**
 * Constant definitions for plug-in preferences
 */
public final class SimulationPreferences {

    public static final String                P_SIMULATION_STEP_DURATION       = "simulation.step.duration";

    public static final double                DEFAULT_SIMULATION_STEP_DURATION = 0.1;

    public static final SimulationPreferences DEFAULT_PREFS
        = new SimulationPreferences(null, DEFAULT_SIMULATION_STEP_DURATION);

    public final IEclipsePreferences          prefs;
    public final double                       stepDuration;

    public SimulationPreferences(double stepDuration) {
        this(null, stepDuration);
    }

    public SimulationPreferences(IEclipsePreferences prefs, double stepDuration) {
        this.prefs = prefs;
        this.stepDuration = stepDuration;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[step duration=" + stepDuration + "]";
    }

}
