/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.simantics.simulation.ui.Activator;


/**
 * @author Tuukka Lehtonen
 */
public final class SimulationPreferenceUtil {

    public static SimulationPreferences getDefaultPrefs() {
        return getPrefs(DefaultScope.INSTANCE);
    }

    /**
     * @return
     */
    public static SimulationPreferences getPrefs() {
        return getPrefs(InstanceScope.INSTANCE);
    }

    /**
     * @return
     */
    public static SimulationPreferences getPrefs(IScopeContext context) {
        IEclipsePreferences node = context.getNode(Activator.PLUGIN_ID);
        double stepDuration = node.getDouble(SimulationPreferences.P_SIMULATION_STEP_DURATION, SimulationPreferences.DEFAULT_SIMULATION_STEP_DURATION);

        return new SimulationPreferences(node, stepDuration);
    }

    /**
     * @return
     * @throws BackingStoreException 
     */
    public static void setPrefs(SimulationPreferences prefs) {
        setPrefs(InstanceScope.INSTANCE, prefs);
    }

    /**
     * @return
     * @throws BackingStoreException 
     */
    public static void flushPrefs(SimulationPreferences prefs) throws BackingStoreException {
        Preferences p = _setPrefs(InstanceScope.INSTANCE, prefs);
        p.flush();
    }

    /**
     * @return
     * @throws BackingStoreException 
     */
    public static void setPrefs(IScopeContext context, SimulationPreferences prefs) {
        _setPrefs(context, prefs);
    }

    /**
     * @return
     * @throws BackingStoreException 
     */
    private static IEclipsePreferences _setPrefs(IScopeContext context, SimulationPreferences prefs) {
        IEclipsePreferences node = context.getNode(Activator.PLUGIN_ID);
        node.putDouble(SimulationPreferences.P_SIMULATION_STEP_DURATION, prefs.stepDuration);
        return node;
    }

}
