/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers.e4;

import javax.annotation.PostConstruct;
import javax.inject.Inject;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.simantics.Simantics;
import org.simantics.simulation.SimulationEvents;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;

public class Step {

    private static final String HANDLED_ITEM_ID = "org.simantics.simulation.ui.handledtoolitem.step";

    @Inject
    EModelService modelService;
    
    @PostConstruct
    public void updateToolTip(MApplication application) {
        MHandledItem handledItem = (MHandledItem) modelService.find(HANDLED_ITEM_ID, application);
        if (handledItem != null) {
            SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();
            handledItem.setTooltip("Step " + prefs.stepDuration + "s");
        }
    }
    
    @CanExecute
    public boolean canExecute() {
        IExperimentManager manager = Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null)
            return false;
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment == null)
            return false;
        return true;
    }
    
    @Execute
    public void execute() {
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();
        ExperimentUtil.step(prefs.stepDuration);
    }

    @Inject
    @Optional
    public void updateElement(@UIEventTopic(SimulationEvents.TOPIC_STEP_DURATION) double duration, MApplication application) {
        MHandledItem handledItem = (MHandledItem) modelService.find(HANDLED_ITEM_ID, application);
        if (handledItem != null) {
            handledItem.setTooltip("Step " + duration + "s");
        }
    }

}
