/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers.e4;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.simulation.SimulationEvents;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.validators.DoubleValidator;

public class SetDuration {

    private IEventBroker eventBroker;
    
    public SetDuration() {
        eventBroker = E4Workbench.getServiceContext().get(IEventBroker.class);
    }
    
    @Execute
    public void execute() {
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();

        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
                "Set Simulation Step Duration", "Simulation step duration in seconds", "" + prefs.stepDuration, new DoubleValidator());
        if (dialog.open() == InputDialog.OK) {
            final double duration = Double.parseDouble(dialog.getValue());
            try {
                SimulationPreferenceUtil.flushPrefs(new SimulationPreferences(duration));
                eventBroker.post(SimulationEvents.TOPIC_STEP_DURATION, duration);
            } catch (BackingStoreException e) {
                ExceptionUtils.logAndShowError(e);
            }
        }
    }

}
