/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers.e4;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.simantics.Simantics;
import org.simantics.simulation.SimulationEvents;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;

public class Run {

    public static final String RUN_STATE_EVENT = "runSimulationEvent";
    public static final String SIMULATION_RUN_STATE = "org.simantics.simulation.ui.run.state";
    private static final String HANDLED_ITEM_ID = "org.simantics.simulation.ui.handledtoolitem.Run";

    @Inject
    EModelService modelService;

    @CanExecute
    public boolean canExecute() {
        IExperimentManager manager = Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null)
            return false;
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment == null)
            return false;
        return true;
    }
    
    @Execute
    public void execute(MHandledItem handledItem) {
        ExperimentUtil.simulate(handledItem.isSelected());
    }

    @Inject
    @Optional
    public void handleEvent(@UIEventTopic(SimulationEvents.TOPIC_STATE_CHANGE) boolean state, MApplication application) {
        List<MHandledItem> items = modelService.findElements(application, HANDLED_ITEM_ID, MHandledItem.class, null);
        if (!items.isEmpty()) {
            for (MHandledItem handledItem : items) {
                handledItem.setSelected(state);
                if (handledItem.isSelected()) {
                    handledItem.setIconURI("platform:/plugin/org.simantics.simulation.ui/icons/control_pause.png");
                    handledItem.setTooltip("Pause");
                } else {
                    handledItem.setIconURI("platform:/plugin/org.simantics.simulation.ui/icons/control_play.png");
                    handledItem.setTooltip("Run");
                }
            }
        }
    }

}
