/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.Activator;
import org.simantics.ui.SimanticsUI;

/**
 * @author Tuukka Lehtonen
 */
public class SaveState extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IExperimentManager manager = SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            Job j = new SaveStateJob((IDynamicExperiment) experiment);
            j.setRule(new ObjectIdentitySchedulingRule(experiment));
            j.schedule();
        }
        return null;
    }

    static class SaveStateJob extends Job {
        private final IDynamicExperiment experiment;

        public SaveStateJob(IDynamicExperiment experiment) {
            super("Save Experiment State");
            this.experiment = experiment;
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", IProgressMonitor.UNKNOWN);
                experiment.saveState();
                if (monitor.isCanceled())
                    return Status.CANCEL_STATUS;
                return Status.OK_STATUS;
            } catch (Throwable t) {
                return new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to save state of dynamic experiment "
                        + experiment + " with ID " + experiment.getIdentifier(), t);
            } finally {
                //System.out.println("DONE");
                monitor.done();
            }
        }
    }

}
