/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.Activator;
import org.simantics.ui.SimanticsUI;

public class Reload extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IExperimentManager manager =
            SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null) {
            Job j = new RefreshJob(experiment);
            j.setRule(new ObjectIdentitySchedulingRule(experiment));
            j.schedule();
        }
        return null;
    }

    static class RefreshJob extends Job {
        private final IExperiment experiment;

        public RefreshJob(IExperiment experiment) {
            super("Refresh Experiment");
            this.experiment = experiment;
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", IProgressMonitor.UNKNOWN);
                experiment.refresh(SimanticsUI.getSession());
                if (monitor.isCanceled())
                    return Status.CANCEL_STATUS;
                return Status.OK_STATUS;
            } catch (Throwable t) {
                return new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to refresh experiment "
                        + experiment + " with ID " + experiment.getIdentifier(), t);
            } finally {
                monitor.done();
            }
        }
    }

}
