package org.simantics.simulation.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class SimulationResource {
    
    public final Resource ActiveExperiment;
    public final Resource Experiment;
    public final Resource ExperimentState;
    public final Resource ExperimentState_Disposed;
    public final Resource ExperimentState_Initializing;
    public final Resource ExperimentState_Running;
    public final Resource ExperimentState_Stopped;
    public final Resource HasActivationTime;
    public final Resource HasActivationTime_Inverse;
    public final Resource HasActiveExperiment;
    public final Resource HasActiveExperiment_Inverse;
    public final Resource HasConfiguration;
    public final Resource HasDevsComponent;
    public final Resource HasExperimentState;
    public final Resource HasInitialState;
    public final Resource HasInitialState_Inverse;
    public final Resource HasState;
    public final Resource HasState_Inverse;
    public final Resource History;
    public final Resource History_History;
    public final Resource History_History_Item;
    public final Resource History_History_Item_Bias;
    public final Resource History_History_Item_Bias_Inverse;
    public final Resource History_History_Item_CollectorState;
    public final Resource History_History_Item_CollectorState_Inverse;
    public final Resource History_History_Item_Deadband;
    public final Resource History_History_Item_Deadband_Inverse;
    public final Resource History_History_Item_Enabled;
    public final Resource History_History_Item_Enabled_Inverse;
    public final Resource History_History_Item_Format;
    public final Resource History_History_Item_FormatId;
    public final Resource History_History_Item_FormatId_Inverse;
    public final Resource History_History_Item_Format_Inverse;
    public final Resource History_History_Item_Gain;
    public final Resource History_History_Item_Gain_Inverse;
    public final Resource History_History_Item_GroupId;
    public final Resource History_History_Item_GroupId_Inverse;
    public final Resource History_History_Item_GroupItemId;
    public final Resource History_History_Item_GroupItemId_Inverse;
    public final Resource History_History_Item_Info;
    public final Resource History_History_Item_Info_Inverse;
    public final Resource History_History_Item_Interval;
    public final Resource History_History_Item_Interval_Inverse;
    public final Resource History_History_Item_Series;
    public final Resource History_History_Item_Series_Inverse;
    public final Resource History_History_Item_VariableId;
    public final Resource History_History_Item_VariableId_Inverse;
    public final Resource History_History_Item_size;
    public final Resource History_History_Item_size_Inverse;
    public final Resource History_History_archive;
    public final Resource History_History_archive_Inverse;
    public final Resource History_History_size;
    public final Resource History_History_size_Inverse;
    public final Resource IsActive;
    public final Resource IsConfigurationOf;
    public final Resource Model;
    public final Resource Run;
    public final Resource RunType;
    public final Resource Run_iExperiment;
    public final Resource Run_iExperiment_Inverse;
    public final Resource State;
    public final Resource State_History;
    public final Resource State_History_Inverse;
        
    public static class URIs {
        public static final String ActiveExperiment = "http://www.simantics.org/Simulation-1.1/ActiveExperiment";
        public static final String Experiment = "http://www.simantics.org/Simulation-1.1/Experiment";
        public static final String ExperimentState = "http://www.simantics.org/Simulation-1.1/ExperimentState";
        public static final String ExperimentState_Disposed = "http://www.simantics.org/Simulation-1.1/ExperimentState/Disposed";
        public static final String ExperimentState_Initializing = "http://www.simantics.org/Simulation-1.1/ExperimentState/Initializing";
        public static final String ExperimentState_Running = "http://www.simantics.org/Simulation-1.1/ExperimentState/Running";
        public static final String ExperimentState_Stopped = "http://www.simantics.org/Simulation-1.1/ExperimentState/Stopped";
        public static final String HasActivationTime = "http://www.simantics.org/Simulation-1.1/HasActivationTime";
        public static final String HasActivationTime_Inverse = "http://www.simantics.org/Simulation-1.1/HasActivationTime/Inverse";
        public static final String HasActiveExperiment = "http://www.simantics.org/Simulation-1.1/HasActiveExperiment";
        public static final String HasActiveExperiment_Inverse = "http://www.simantics.org/Simulation-1.1/HasActiveExperiment/Inverse";
        public static final String HasConfiguration = "http://www.simantics.org/Simulation-1.1/HasConfiguration";
        public static final String HasDevsComponent = "http://www.simantics.org/Simulation-1.1/HasDevsComponent";
        public static final String HasExperimentState = "http://www.simantics.org/Simulation-1.1/HasExperimentState";
        public static final String HasInitialState = "http://www.simantics.org/Simulation-1.1/HasInitialState";
        public static final String HasInitialState_Inverse = "http://www.simantics.org/Simulation-1.1/HasInitialState/Inverse";
        public static final String HasState = "http://www.simantics.org/Simulation-1.1/HasState";
        public static final String HasState_Inverse = "http://www.simantics.org/Simulation-1.1/HasState/Inverse";
        public static final String History = "http://www.simantics.org/Simulation-1.1/History";
        public static final String History_History = "http://www.simantics.org/Simulation-1.1/History/History";
        public static final String History_History_Item = "http://www.simantics.org/Simulation-1.1/History/History/Item";
        public static final String History_History_Item_Bias = "http://www.simantics.org/Simulation-1.1/History/History/Item/Bias";
        public static final String History_History_Item_Bias_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Bias/Inverse";
        public static final String History_History_Item_CollectorState = "http://www.simantics.org/Simulation-1.1/History/History/Item/CollectorState";
        public static final String History_History_Item_CollectorState_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/CollectorState/Inverse";
        public static final String History_History_Item_Deadband = "http://www.simantics.org/Simulation-1.1/History/History/Item/Deadband";
        public static final String History_History_Item_Deadband_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Deadband/Inverse";
        public static final String History_History_Item_Enabled = "http://www.simantics.org/Simulation-1.1/History/History/Item/Enabled";
        public static final String History_History_Item_Enabled_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Enabled/Inverse";
        public static final String History_History_Item_Format = "http://www.simantics.org/Simulation-1.1/History/History/Item/Format";
        public static final String History_History_Item_FormatId = "http://www.simantics.org/Simulation-1.1/History/History/Item/FormatId";
        public static final String History_History_Item_FormatId_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/FormatId/Inverse";
        public static final String History_History_Item_Format_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Format/Inverse";
        public static final String History_History_Item_Gain = "http://www.simantics.org/Simulation-1.1/History/History/Item/Gain";
        public static final String History_History_Item_Gain_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Gain/Inverse";
        public static final String History_History_Item_GroupId = "http://www.simantics.org/Simulation-1.1/History/History/Item/GroupId";
        public static final String History_History_Item_GroupId_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/GroupId/Inverse";
        public static final String History_History_Item_GroupItemId = "http://www.simantics.org/Simulation-1.1/History/History/Item/GroupItemId";
        public static final String History_History_Item_GroupItemId_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/GroupItemId/Inverse";
        public static final String History_History_Item_Info = "http://www.simantics.org/Simulation-1.1/History/History/Item/Info";
        public static final String History_History_Item_Info_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Info/Inverse";
        public static final String History_History_Item_Interval = "http://www.simantics.org/Simulation-1.1/History/History/Item/Interval";
        public static final String History_History_Item_Interval_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Interval/Inverse";
        public static final String History_History_Item_Series = "http://www.simantics.org/Simulation-1.1/History/History/Item/Series";
        public static final String History_History_Item_Series_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/Series/Inverse";
        public static final String History_History_Item_VariableId = "http://www.simantics.org/Simulation-1.1/History/History/Item/VariableId";
        public static final String History_History_Item_VariableId_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/VariableId/Inverse";
        public static final String History_History_Item_size = "http://www.simantics.org/Simulation-1.1/History/History/Item/size";
        public static final String History_History_Item_size_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/Item/size/Inverse";
        public static final String History_History_archive = "http://www.simantics.org/Simulation-1.1/History/History/archive";
        public static final String History_History_archive_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/archive/Inverse";
        public static final String History_History_size = "http://www.simantics.org/Simulation-1.1/History/History/size";
        public static final String History_History_size_Inverse = "http://www.simantics.org/Simulation-1.1/History/History/size/Inverse";
        public static final String IsActive = "http://www.simantics.org/Simulation-1.1/IsActive";
        public static final String IsConfigurationOf = "http://www.simantics.org/Simulation-1.1/IsConfigurationOf";
        public static final String Model = "http://www.simantics.org/Simulation-1.1/Model";
        public static final String Run = "http://www.simantics.org/Simulation-1.1/Run";
        public static final String RunType = "http://www.simantics.org/Simulation-1.1/RunType";
        public static final String Run_iExperiment = "http://www.simantics.org/Simulation-1.1/Run/iExperiment";
        public static final String Run_iExperiment_Inverse = "http://www.simantics.org/Simulation-1.1/Run/iExperiment/Inverse";
        public static final String State = "http://www.simantics.org/Simulation-1.1/State";
        public static final String State_History = "http://www.simantics.org/Simulation-1.1/State/History";
        public static final String State_History_Inverse = "http://www.simantics.org/Simulation-1.1/State/History/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public SimulationResource(ReadGraph graph) {
        ActiveExperiment = getResourceOrNull(graph, URIs.ActiveExperiment);
        Experiment = getResourceOrNull(graph, URIs.Experiment);
        ExperimentState = getResourceOrNull(graph, URIs.ExperimentState);
        ExperimentState_Disposed = getResourceOrNull(graph, URIs.ExperimentState_Disposed);
        ExperimentState_Initializing = getResourceOrNull(graph, URIs.ExperimentState_Initializing);
        ExperimentState_Running = getResourceOrNull(graph, URIs.ExperimentState_Running);
        ExperimentState_Stopped = getResourceOrNull(graph, URIs.ExperimentState_Stopped);
        HasActivationTime = getResourceOrNull(graph, URIs.HasActivationTime);
        HasActivationTime_Inverse = getResourceOrNull(graph, URIs.HasActivationTime_Inverse);
        HasActiveExperiment = getResourceOrNull(graph, URIs.HasActiveExperiment);
        HasActiveExperiment_Inverse = getResourceOrNull(graph, URIs.HasActiveExperiment_Inverse);
        HasConfiguration = getResourceOrNull(graph, URIs.HasConfiguration);
        HasDevsComponent = getResourceOrNull(graph, URIs.HasDevsComponent);
        HasExperimentState = getResourceOrNull(graph, URIs.HasExperimentState);
        HasInitialState = getResourceOrNull(graph, URIs.HasInitialState);
        HasInitialState_Inverse = getResourceOrNull(graph, URIs.HasInitialState_Inverse);
        HasState = getResourceOrNull(graph, URIs.HasState);
        HasState_Inverse = getResourceOrNull(graph, URIs.HasState_Inverse);
        History = getResourceOrNull(graph, URIs.History);
        History_History = getResourceOrNull(graph, URIs.History_History);
        History_History_Item = getResourceOrNull(graph, URIs.History_History_Item);
        History_History_Item_Bias = getResourceOrNull(graph, URIs.History_History_Item_Bias);
        History_History_Item_Bias_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Bias_Inverse);
        History_History_Item_CollectorState = getResourceOrNull(graph, URIs.History_History_Item_CollectorState);
        History_History_Item_CollectorState_Inverse = getResourceOrNull(graph, URIs.History_History_Item_CollectorState_Inverse);
        History_History_Item_Deadband = getResourceOrNull(graph, URIs.History_History_Item_Deadband);
        History_History_Item_Deadband_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Deadband_Inverse);
        History_History_Item_Enabled = getResourceOrNull(graph, URIs.History_History_Item_Enabled);
        History_History_Item_Enabled_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Enabled_Inverse);
        History_History_Item_Format = getResourceOrNull(graph, URIs.History_History_Item_Format);
        History_History_Item_FormatId = getResourceOrNull(graph, URIs.History_History_Item_FormatId);
        History_History_Item_FormatId_Inverse = getResourceOrNull(graph, URIs.History_History_Item_FormatId_Inverse);
        History_History_Item_Format_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Format_Inverse);
        History_History_Item_Gain = getResourceOrNull(graph, URIs.History_History_Item_Gain);
        History_History_Item_Gain_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Gain_Inverse);
        History_History_Item_GroupId = getResourceOrNull(graph, URIs.History_History_Item_GroupId);
        History_History_Item_GroupId_Inverse = getResourceOrNull(graph, URIs.History_History_Item_GroupId_Inverse);
        History_History_Item_GroupItemId = getResourceOrNull(graph, URIs.History_History_Item_GroupItemId);
        History_History_Item_GroupItemId_Inverse = getResourceOrNull(graph, URIs.History_History_Item_GroupItemId_Inverse);
        History_History_Item_Info = getResourceOrNull(graph, URIs.History_History_Item_Info);
        History_History_Item_Info_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Info_Inverse);
        History_History_Item_Interval = getResourceOrNull(graph, URIs.History_History_Item_Interval);
        History_History_Item_Interval_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Interval_Inverse);
        History_History_Item_Series = getResourceOrNull(graph, URIs.History_History_Item_Series);
        History_History_Item_Series_Inverse = getResourceOrNull(graph, URIs.History_History_Item_Series_Inverse);
        History_History_Item_VariableId = getResourceOrNull(graph, URIs.History_History_Item_VariableId);
        History_History_Item_VariableId_Inverse = getResourceOrNull(graph, URIs.History_History_Item_VariableId_Inverse);
        History_History_Item_size = getResourceOrNull(graph, URIs.History_History_Item_size);
        History_History_Item_size_Inverse = getResourceOrNull(graph, URIs.History_History_Item_size_Inverse);
        History_History_archive = getResourceOrNull(graph, URIs.History_History_archive);
        History_History_archive_Inverse = getResourceOrNull(graph, URIs.History_History_archive_Inverse);
        History_History_size = getResourceOrNull(graph, URIs.History_History_size);
        History_History_size_Inverse = getResourceOrNull(graph, URIs.History_History_size_Inverse);
        IsActive = getResourceOrNull(graph, URIs.IsActive);
        IsConfigurationOf = getResourceOrNull(graph, URIs.IsConfigurationOf);
        Model = getResourceOrNull(graph, URIs.Model);
        Run = getResourceOrNull(graph, URIs.Run);
        RunType = getResourceOrNull(graph, URIs.RunType);
        Run_iExperiment = getResourceOrNull(graph, URIs.Run_iExperiment);
        Run_iExperiment_Inverse = getResourceOrNull(graph, URIs.Run_iExperiment_Inverse);
        State = getResourceOrNull(graph, URIs.State);
        State_History = getResourceOrNull(graph, URIs.State_History);
        State_History_Inverse = getResourceOrNull(graph, URIs.State_History_Inverse);
    }
    
    public static SimulationResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        SimulationResource ret = session.peekService(SimulationResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new SimulationResource(qc.getIndependentGraph(graph));
            session.registerService(SimulationResource.class, ret);
        }
        return ret;
    }
    
    public static SimulationResource getInstance(RequestProcessor session) throws DatabaseException {
        SimulationResource ret = session.peekService(SimulationResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<SimulationResource>() {
                public SimulationResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new SimulationResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(SimulationResource.class, ret);
        }
        return ret;
    }
    
}

