/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.IPageSite;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.db.ReadGraph;

/**
 * @author Antti Villberg
 * 
 * @see StandardPropertyPage
 */
public class StandardProperties extends TabbedPropertyTable implements IFilterAreaProvider, IPropertyTab {

    /**
     * @param site
     * @param pageSite
     * @param parent
     * @param style
     * @param browseContexts the browse contexts to use for loading this
     *        property table
     * @param selectionProcessors a fixed set of selection processors, may be
     *        <code>null</code>
     */
    public StandardProperties(IWorkbenchPartSite site, IPageSite pageSite, Composite parent, int style,
            final Set<String> browseContexts, final Collection<SelectionProcessor<?, ?>> selectionProcessors) {
        super(site, pageSite, parent, style);

        final Set<SelectionProcessor<?, ?>> processors = new HashSet<SelectionProcessor<?, ?>>();
        if (selectionProcessors != null)
            processors.addAll(selectionProcessors);

        //System.out.println("StandardProperties with contexts: " + browseContexts);
        for (final SelectionProcessorBinding binding : SelectionProcessorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            //System.out.println("found " + binding.getProcessor());
            processors.add(binding.getProcessor());
        }

        setSelectionProcessor(new SelectionProcessor<Object, ReadGraph>() {

            @SuppressWarnings({ "rawtypes", "unchecked" })
            @Override
            public Collection<?> process(final Object selection, ReadGraph graph) {

                HashSet<Object> l     = new HashSet<Object>();
                for (SelectionProcessor p : processors) {
                    Collection<?> c = p.process(selection, graph);
                    if (c != null) {
                        l.addAll(c);
                    } else {
                        ErrorLogger.defaultLogWarning("SelectionProcessor '" + p + "' invalidly returned null with selection '" + selection + "'", null);
                    }
                }

                return l;

            }

        });
    }

    @Override
    public IFilterArea getFilterArea() {
        IPropertyTab active = getActiveTab();
        if (!(active instanceof IFilterAreaProvider))
            return null;
        return ((IFilterAreaProvider) active).getFilterArea();
    }

}
