package org.simantics.selectionview;

import java.util.Collection;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

abstract public class AbstractVariableTabContribution implements TabContribution<Object> {

	final private String uri;
	final protected Resource configuration;

	public AbstractVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		this.configuration = configuration;
		this.uri = graph.getURI(configuration);
	}

	public abstract void getContributors(ReadGraph graph, Variable variable, Integer priority, String label, Collection<ComparableTabContributor> result) throws DatabaseException;

	@Override
	public boolean accept(ReadGraph graph, Object input) throws DatabaseException {
		return true;
	}

	public boolean accept(ReadGraph graph, Variable variable, Object selection) throws DatabaseException {

		if(selection instanceof SelectionInput) {
		
			SelectionViewResources SEL = SelectionViewResources.getInstance(graph);
			for(Resource r : graph.getObjects(configuration, SEL.AbstractVariableTabContribution_HasTest)) {
				Boolean pass = Functions.exec(graph, r, graph, (SelectionInput)selection);
				if(!pass) return false;
			}
		
			Variable configurationVariable = Variables.getVariable(graph, configuration);
			Function f = configurationVariable.getPossiblePropertyValue(graph, SEL.AbstractVariableTabContribution_testFunction);
			if(f != null) {
				Boolean pass = Simantics.<Boolean>applySCLRead(graph, f, variable);
				if(!pass) return false;
			}
			
		} else {
			
			return false;
			
		}
		
		return true;
		
	}
	
	final private Variable getPossibleVariable(ReadGraph graph, Object selection) throws DatabaseException {
		if(selection instanceof SelectionInput) {
			SelectionInput si = (SelectionInput)selection;
			if(si.getElements().size() == 1) {
				return WorkbenchSelectionUtils.getPossibleVariable(graph, si.getElements().iterator().next());
			}
		}
		return null;
	} 
	
	@Override
	final public void contribute(ReadGraph graph, final Object selection, Collection<ComparableTabContributor> result) throws DatabaseException {
		
		Variable variable = getPossibleVariable(graph, selection);
		if(variable == null) return;

		Layer0 L0 = Layer0.getInstance(graph);
		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);

		Integer priority = graph.getPossibleRelatedValue(configuration, SEL.AbstractVariableTabContribution_HasPriority, Bindings.INTEGER);
		String label = graph.getPossibleRelatedValue(configuration, L0.HasLabel);
		
		if(!accept(graph, variable, selection)) return;

		getContributors(graph, variable, priority, label, result);		

	}
	
	@Override
	public String toString() {
		return "AbstractVariableTabContribution[" + uri + "]";
	}

}
