package org.simantics.scl.ui.imports.internal;

import java.util.ArrayList;

import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.imports.ImportModulesAction;

public class ExternalImportModulesAction extends ImportModulesAction {
    
    public static final ExternalImportModulesAction INSTANCE = new ExternalImportModulesAction();
            
    public ExternalImportModulesAction() {
        super("Add external module", 95.0);
    }

    @Override
    public boolean editImports(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        FileDialog dialog = new FileDialog(shell);
        dialog.setFilterExtensions(new String[] {"*.scl"});
        
        String result = dialog.open();
        if(result != null) {
            new CommandSessionImportEntry("file:" + result, "", true).addTo(imports);
            return true;
        }
        else
            return false;
    }

}
