package org.simantics.scl.ui.editor2;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class SCLPartitionScanner extends RuleBasedPartitionScanner {
    public static final String SCL_COMMENT = "COMMENT";
    public static final String SCL_STRING = "STRING";
    
    public static final IToken COMMENT_TOKEN = new Token(SCL_COMMENT);
    public static final IToken STRING_TOKEN = new Token(SCL_STRING);
    
    public static final String[] PARTITION_TYPES = new String[] {
            SCL_COMMENT,
            SCL_STRING
    };
    
    public SCLPartitionScanner() {
        super();

        setPredicateRules(new IPredicateRule[] {
                new EndOfLineRule("//", COMMENT_TOKEN),
                new MultiLineRule("\"\"\"", "\"\"\"", STRING_TOKEN, (char) 0, true),
                new SingleLineRule("\"", "\"", STRING_TOKEN, '\\'),
                new MultiLineRule("/*", "*/", COMMENT_TOKEN, (char) 0, true),
        });
    }
}
