package org.simantics.scl.ui.editor2;

import java.io.IOException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.TextualModuleSource;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;

public class SCLModuleEditor2DocumentProvider extends AbstractDocumentProvider {

    private SCLSourceViewerConfigurationNew sourceViewer;
    protected AnnotationModel annotationModel = new AnnotationModel();
    
    public SCLModuleEditor2DocumentProvider(
            SCLSourceViewerConfigurationNew sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    private static TextualModuleSource toTextualModuleSource(Object input) {
        if(!(input instanceof SCLModuleEditorInput))
            return null;
        ModuleSource source = ((SCLModuleEditorInput)input).getAdapter(ModuleSource.class);
        if(source == null)
            return null;
        if(!(source instanceof TextualModuleSource))
            return null;
        return (TextualModuleSource)source;
    }
    
    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        TextualModuleSource source = toTextualModuleSource(element);
        if(source == null)
            throw new CoreException(
                    new Status(Status.ERROR, "org.simantics.scl.ui", "Source for the SCL module could not be found.")
                    );
        Document document;
        try {
            document = new Document(source.getSourceText(null));
        } catch (IOException e) {
            throw new CoreException(
                    new Status(Status.ERROR, "org.simantics.scl.ui", "Reading SCL module failed.", e)
                    );
        }
        IDocumentPartitioner partitioner = new FastPartitioner(new SCLPartitionScanner(), SCLPartitionScanner.PARTITION_TYPES);
        partitioner.connect(document);
        document.setDocumentPartitioner(partitioner);
        sourceViewer.updateCompletionAssistModuleName(source.getModuleName());
        return document;
    }
    
    @Override
    public boolean isModifiable(Object element) {
        TextualModuleSource source = toTextualModuleSource(element);
        if(source == null)
            return false;
        return source.isUpdateable();
    }
    
    @Override
    public boolean isReadOnly(Object element) {
        return !isModifiable(element);
    }

    @Override
    protected IAnnotationModel createAnnotationModel(Object element)
            throws CoreException {
        SCLModuleEditorInput input = (SCLModuleEditorInput)element;
        return new SCLAnnotationModel(input, SCLOsgi.MODULE_REPOSITORY);
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element,
            IDocument document, boolean overwrite) throws CoreException {
        TextualModuleSource source = toTextualModuleSource(element);
        if(source == null)
            return;
        source.update(document.get());
    }

    @Override
    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        // TODO Auto-generated method stub
        return null;
    }

}
