package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenSCLModule extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SCLModuleSelectionDialog dialog = new SCLModuleSelectionDialog(
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if(dialog.open() == SCLModuleSelectionDialog.OK) {
            String moduleName = (String)dialog.getFirstResult();
            openModule(moduleName);
        }
        return null;
    }

    public static void openModule(String moduleName) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if(page == null)
            return;
        SCLModuleEditorInput input = new StandardSCLModuleEditorInput(moduleName);
        try {
            page.openEditor(input, "org.simantics.scl.ui.editor2");
        } catch (PartInitException e) {
            e.printStackTrace();
        }
    }

}
