package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.ui.browser.SCLDefinitionSelectionDialog;

public class OpenSCLDefinition extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SCLDefinitionSelectionDialog dialog = new SCLDefinitionSelectionDialog(
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if(dialog.open() == SCLDefinitionSelectionDialog.OK) {
            SCLValue value = (SCLValue)dialog.getFirstResult();
            if(value != null)
                openDefinition(value);
        }
        return null;
    }
    
    public static void openDefinition(SCLValue value) {
        openDefinition(value.getName().module, value.definitionLocation);
    }
    
    public static void openDefinition(String moduleName, long location) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if(page == null)
            return;
        SCLModuleEditorInput input = new StandardSCLModuleEditorInput(moduleName);
        try {
            SCLModuleEditor2 editor = (SCLModuleEditor2)page.openEditor(input, "org.simantics.scl.ui.editor2");
            if(location != Locations.NO_LOCATION) {
                int begin = Locations.beginOf(location);
                int end = Locations.endOf(location);
                editor.selectAndReveal(begin, end-begin);
            }
        } catch (PartInitException e) {
            e.printStackTrace();
        }
    }

}
