package org.simantics.scl.ui.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

final class SCLAnnotationAccessNew implements IAnnotationAccess, IAnnotationAccessExtension {

    ImageRegistry registry;
    
    public SCLAnnotationAccessNew(ImageRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Object getType(Annotation annotation) {
        return annotation.getType();
    }

    @Override
    public boolean isMultiLine(Annotation annotation) {
        return true;
    }

    @Override
    public boolean isTemporary(Annotation annotation) {
        return !annotation.isPersistent();
    }

    @Override
    public String getTypeLabel(Annotation annotation) {
        return annotation.getType();
    }

    @Override
    public int getLayer(Annotation annotation) {
        return 0;
    }

    @Override
    public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
        Image image = registry.get("error");
        if(image == null) {
            registry.put("error", ImageDescriptor.createFromFile(getClass(), "error_tsk.gif"));
            image = registry.get("error");
        }
        ImageUtilities.drawImage(image, gc, canvas, bounds, SWT.CENTER, SWT.TOP);
    }

    @Override
    public boolean isPaintable(Annotation annotation) {
        return true;
    }

    @Override
    public boolean isSubtype(Object annotationType, Object potentialSupertype) {
        return annotationType.equals(potentialSupertype);
    }

    @Override
    public Object[] getSupertypes(Object annotationType) {
        return new Object[0];
    }
}