package org.simantics.scl.ui.editor;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.scl.compiler.SCLCompiler;
import org.simantics.scl.compiler.StandardSCLCompilerConfiguration;

public class TestTextEditor {

    public static void main(String[] args) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setText("SCL text widget example");
        shell.setLayout(new FillLayout());
        
        SashForm sashForm = new SashForm(shell, SWT.VERTICAL);        
        
        final SCLTextEditor editor = new SCLTextEditor(sashForm, 0, StandardSCLCompilerConfiguration.INSTANCE);
        editor.setContent(
             "// Difficulty: 0\n" +
             "// Expected: [2.0, 3.0, 5.0, 7.0, 11.0, 13.0, 17.0, 19.0]\n\n" +
             "// and : [Boolean] -> Boolean\n" +
             "and = fold (&&) True\n\n" +
             "// isPrime : Integer -> Boolean\n" +
             "isPrime p = and (\n" +
             "    d <- [2 .. sqrt p]\n" +
             "    [p % d > 0]\n" +
             ")\n\n" +
             "x <- [2 .. 20]\n" +
             "isPrime x\n" +
             "[x]"
          );
        
        final Text resultArea = new Text(sashForm, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
        resultArea.setText("Ctrl-S executes the code.");
        resultArea.setEditable(false);
        resultArea.setBackground(new Color(shell.getDisplay(), 255, 255, 255));
        resultArea.setFont(new Font(shell.getDisplay(), "Courier New", 10, SWT.NORMAL));
        
        sashForm.setWeights(new int[] {5, 1});
        
        display.addFilter(SWT.KeyDown, new Listener() {
            @Override
            public void handleEvent(Event event) {
                if(event.keyCode == 's' && event.stateMask == SWT.CTRL) {
                    final String code = editor.getContent();
                    new Thread() {
                        public void run() {
                            try {
                                final String result = SCLCompiler.compileExpression(StandardSCLCompilerConfiguration.INSTANCE, code).execute().toString();
                                shell.getDisplay().asyncExec(new Runnable() {
                                    public void run() {
                                        resultArea.setText(result);    
                                    }                                                
                                });
                            } catch (Exception e) {
                            }
                        }
                    }.start();
                    event.doit = false;
                }
            }
        });
        shell.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println(e);
            }
        });
        
        shell.open();
        while (!shell.isDisposed ()) {
            if (!display.readAndDispatch ()) display.sleep ();
        }
        display.dispose ();
    }
    
}
