package org.simantics.scl.reflection.internal.typeRegistry;

import gnu.trove.set.hash.THashSet;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.reflection.TypeNotFoundException;
import org.simantics.scl.reflection.internal.registry.BindingRegistry;

public class TypeRegistry {
    private static final ConcurrentHashMap<TCon, Class<?>> map = 
            new ConcurrentHashMap<TCon, Class<?>>();
    
    private static final THashSet<String> builtins = new THashSet<String>();
    
    static {
        map.put(Types.BOOLEAN, Boolean.class);        
        map.put(Types.BYTE, Byte.class);
        map.put(Types.CHARACTER, Character.class);
        map.put(Types.SHORT, Short.class);
        map.put(Types.INTEGER, Integer.class);
        map.put(Types.LONG, Long.class);
        map.put(Types.FLOAT, Float.class);
        map.put(Types.DOUBLE, Double.class);
        map.put(Types.STRING, String.class);
        map.put(Types.BYTE_ARRAY, byte[].class);
        
        map.put(Types.LIST, List.class);
        for(int i=0;i<8;++i)
            if(i != 1)
                try {
                    map.put(Types.tupleConstructor(i), 
                            Class.forName("org.simantics.scl.runtime.tuple.Tuple" + i));
                } catch(ClassNotFoundException e) {
                    e.printStackTrace();
                }
        
        for(TCon con : map.keySet())
            builtins.add(con.name);
    }
    
    public static Class<?> getClass(TCon type) throws TypeNotFoundException {
        Class<?> clazz = map.get(type);
        if(clazz == null) {
            try {
                clazz = BindingRegistry.getClass(type);
            } catch(TypeNotFoundException e) {
                e.printStackTrace();
                throw e;
            }
            map.put(type, clazz);
        }
        return clazz;
    }
    
    public static boolean isBuiltin(String name) {
        return builtins.contains(name);
    }
}
