package org.simantics.scl.reflection.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator implements BundleActivator {

    private BundleContext context;  
    
    private static Activator instance;
    
    @Override
    public void start(BundleContext context) throws Exception {
        this.context = context;
        instance = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.context = null;
    }
    
    public BundleContext getContext() {
        return context;
    }
    
    public static Activator getInstance() {
        return instance;
    }
        
    public static void logError(String description, Exception e) {
        System.err.println(description);
        if(e != null)
            e.printStackTrace();
        Bundle bundle = getInstance().getContext().getBundle();
        ILog log = Platform.getLog(bundle);
        log.log(new Status(Status.ERROR, bundle.getSymbolicName(), description, e));
    }
    
    public static void logError(String description) {
        logError(description, null);
    }

}
