package org.simantics.scl.reflection;

import org.simantics.scl.compiler.types.Type;

/**
 * SCL together with its type.
 * @author Hannu Niemist&ouml;
 */
public class TypedValue {
    final Type type;
    final Object value;
    
    public TypedValue(Type type, Object value) {
        this.type = type;
        this.value = value;
    }
    
    @Override
    public String toString() {
        return value.toString() + " :: " + type;
    }
    
    public Type getType() {
        return type;
    }
    
    public Object getValue() {
        return value;
    }
}