package org.simantics.scl.expressions;

import org.simantics.scl.compiler.types.Type;

/**
 * A value that depends on some context. For example SCL expression
 * can be compiled into contextual value where the actual value
 * depends on the free variables of the expression.
 * @author Hannu Niemist&ouml;
 * @param <Context>
 */
public interface ContextualValue<Context> {
    /**
     * SCL type of the value.
     * @return
     */
    Type getType();
    
    /**
     * Evaluates the value in the given context.
     * @param context
     * @return
     */
    Object getValue(Context context);
}
