package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class TextNode extends Node {
    public TextNode(StringBuilder text) {
        this.stringContent = text;
    }
    @Override
    public void toHtml(StringBuilder b) {
        b.append(HtmlEscape.escape(stringContent));
    }
    @Override
    public void toPlainText(StringBuilder b) {
        b.append(HtmlEscape.escape(stringContent));
    }
}
