package org.simantics.scl.compiler.markdown.nodes;

import java.util.ArrayList;
import java.util.List;

import org.simantics.scl.compiler.markdown.internal.ExtensionNodeHandler;
import org.simantics.scl.compiler.markdown.internal.MarkdownParser;


public abstract class Node {
    public Node next;
    public Node prev;
    public Node parent;
    public Node firstChild;
    public Node lastChild;
    public boolean open = true;
    public boolean lastLineBlank = false;
    public StringBuilder stringContent;
    public int lineNumber;
    
    public void setLastLineBlank(boolean value) {
        if(MarkdownParser.DEBUG)
            System.out.println("    " + getClass().getSimpleName() + "@" + hashCode() + " lastLineBlank: " +
                    lastLineBlank + " -> " + value);
        this.lastLineBlank = value;
    }
    
    public boolean canContain(Node node) {
        return false;
    }

    public boolean acceptLines() {
        return false;
    }
    
    public void toHtml(StringBuilder b) {
        for(Node child = firstChild; child != null; child = child.next)
            child.toHtml(b);
    }
    
    public List<HeaderNode> extractHeaders() {
        ArrayList<HeaderNode> result = new ArrayList<HeaderNode>();
        for(Node child = firstChild; child != null; child = child.next)
            if(child instanceof HeaderNode)
                result.add((HeaderNode)child);
        return result;
    }
    
    public String toHtml() {
        StringBuilder b = new StringBuilder();
        toHtml(b);
        int len = b.length();
        if(len > 0 && b.charAt(len-1) == '\n')
            b.delete(len-1, len);
        return b.toString();
    }
    
    public void toPlainText(StringBuilder b) {
        for(Node child = firstChild; child != null; child = child.next)
            child.toPlainText(b);
    }
    
    public void remove() {
        if(prev == null)
            parent.firstChild = next;
        else
            prev.next = next;
        if(next == null)
            parent.lastChild = prev;
        else
            next.prev = prev;
    }
    
    public void processExtensionNodes(ExtensionNodeHandler handler) {
        for(Node child = firstChild; child != null; child = child.next)
            child.processExtensionNodes(handler);
    }

    public void addChild(Node child) {
        child.parent = this;
        if(lastChild == null)
           firstChild = child; 
        else {
            lastChild.next = child;
            child.prev = lastChild;
        }
        lastChild = child;
    }
}
