package org.simantics.scl.compiler.markdown.nodes;


public class ListNode extends Node {
    public char bulletChar;
    public boolean tight;
    public int start;
    
    public ListNode(char bulletChar) {
        this.bulletChar = bulletChar;
    }

    public ListNode(char bulletChar, int start) {
        this.bulletChar = bulletChar;
        this.start = start;
    }

    @Override
    public boolean canContain(Node node) {
        return node instanceof ItemNode;
    }

    public boolean isCompatible(char bulletChar) {
        return bulletChar == this.bulletChar;
    }
    
    @Override
    public void toHtml(StringBuilder b) {
        if(bulletChar == '+' || bulletChar == '-' || bulletChar == '*') {
            b.append("<ul>\n");
            for(Node child = firstChild; child != null; child = child.next)
                ((ItemNode)child).toHtml(b, tight);
            b.append("</ul>\n");
        }
        else {
            if(start == 1)
                b.append("<ol>\n");
            else
                b.append("<ol start=\"").append(start).append("\">\n");
            for(Node child = firstChild; child != null; child = child.next)
                ((ItemNode)child).toHtml(b, tight);
            b.append("</ol>\n");
        }
    }
}
