package org.simantics.scl.compiler.markdown.nodes;


public class HeaderNode extends Node {
    public int level;
    public boolean setext;

    public HeaderNode(int level, boolean setext) {
        this.level = level;
        this.setext = setext;
    }
    
    @Override
    public boolean acceptLines() {
        return !setext;
    }
    
    @Override
    public void toHtml(StringBuilder b) {
        b.append("<h").append(level).append(" id=\"");
        toPlainText(b);
        b.append("\">");
        super.toHtml(b);
        b.append("</h").append(level).append(">\n");
    }
}
