package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class CodeNode extends Node {
    public CodeNode(StringBuilder stringContent) {
        this.stringContent = stringContent;
    }
    
    @Override
    public void toHtml(StringBuilder b) {
        b.append("<code>");
        b.append(HtmlEscape.escape(stringContent));
        b.append("</code>");
    }
}
