package org.simantics.scl.compiler.markdown.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;

public class HierarchicalDocumentationRef implements Comparable<HierarchicalDocumentationRef> {
    final String name;
    final ArrayList<HierarchicalDocumentationRef> children = new ArrayList<HierarchicalDocumentationRef>();
    String documentationName;
    
    public HierarchicalDocumentationRef(String name) {
        this.name = name;
    }
    
    public String getName() {
        return name;
    }
    
    public String getDocumentationName() {
        return documentationName;
    }
    
    public List<HierarchicalDocumentationRef> getChildren() {
        return children;
    }

    @Override
    public int compareTo(HierarchicalDocumentationRef o) {
        return name.compareTo(o.name);
    }
    
    public static HierarchicalDocumentationRef generateTree(ModuleSourceRepository sourceRepository) {
        final THashMap<String,HierarchicalDocumentationRef> refMap = new THashMap<String,HierarchicalDocumentationRef>();
        HierarchicalDocumentationRef root = new HierarchicalDocumentationRef("");
        refMap.put("", root);
        final THashSet<String> documentationPaths = new THashSet<String>(); 
        TObjectProcedure<String> collector = new TObjectProcedure<String>() {
            @Override
            public boolean execute(String path) {
                documentationPaths.add(path);
                return true;
            }
        };
        sourceRepository.forAllDocumentations(collector);
        sourceRepository.forAllModules(collector);
        documentationPaths.forEach(new TObjectProcedure<String>() {
            HierarchicalDocumentationRef getRef(String path) {
                HierarchicalDocumentationRef ref = refMap.get(path);
                if(ref == null) {
                    String name;
                    String parentName;
                    int p = path.lastIndexOf('/');
                    if(p >= 0) {
                        name = path.substring(p+1);
                        parentName = path.substring(0, p);
                    }
                    else {
                        name = path;
                        parentName = "";
                    }
                    ref = new HierarchicalDocumentationRef(name);
                    refMap.put(path, ref);
                    getRef(parentName).children.add(ref);
                }
                return ref;
            }   
            
            @Override
            public boolean execute(String documentationName) {
                getRef(documentationName.contains("/")
                        ? documentationName : "StandardLibrary/" + documentationName)
                        .documentationName = documentationName;
                return true;
            }
        });
        
        root.sort();
        
        return root;
    }

    private void sort() {
        Collections.sort(children);
        for(HierarchicalDocumentationRef child : children)
            child.sort();
    }
}