package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;



public class TVarAst extends TypeAst {    
    public final String name;
    
    public TVarAst(String name) {
        this.name = name;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append(name);
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        return context.resolveTypeVariable(name);
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}
