package org.simantics.scl.compiler.internal.types;

import org.simantics.scl.compiler.types.TVar;

import gnu.trove.map.hash.TObjectIntHashMap;

public class TypeHashCodeContext {
        
    public static final int APPLY = 0x12345678;
    public static final int FORALL = 0xf2341233;
    public static final int UNION = 0x9f8f7f6f;
    public static final int FUN = 0xff294313;
    
    int result;
    TObjectIntHashMap<TVar> varHashCode;
    
    public void append(int hash) {
        result = result*31 + hash;
    }
    
    public int getResult() {
        return result;
    }
    
    public TObjectIntHashMap<TVar> getVarHashCode() {
        return varHashCode;
    }
    
    public TObjectIntHashMap<TVar> createVarHashCode() {
        if(varHashCode == null)
            varHashCode = new TObjectIntHashMap<TVar>();
        return varHashCode;
    }
}
