package org.simantics.scl.compiler.internal.parsing.translation;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;

import gnu.trove.impl.Constants;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectLongHashMap;

public class ValueRepository {
    THashMap<String, ArrayList<DValueAst>> values = 
            new THashMap<String, ArrayList<DValueAst>>();
    THashMap<String, ArrayList<DAnnotationAst>> annotations = 
            new THashMap<String, ArrayList<DAnnotationAst>>();
    TObjectLongHashMap<String> locations = new TObjectLongHashMap<String>(Constants.DEFAULT_CAPACITY, Constants.DEFAULT_LOAD_FACTOR,
            Locations.NO_LOCATION); 
            
    public String add(DValueAst value) throws NotPatternException {
        EVar name = value.lhs.getPatternHead();
        ArrayList<DValueAst> vs = values.get(name.name);
        if(vs == null) {
            vs = new ArrayList<DValueAst>(2);
            values.put(name.name, vs);
        }
        long oldLocation = locations.get(name.name);
        if(oldLocation == Locations.NO_LOCATION || name.location < oldLocation)
            locations.put(name.name, name.location);
        vs.add(value);
        return name.name;
    }
    
    public void addDefinitions(String name, ArrayList<DValueAst> valueList) {
        ArrayList<DValueAst> vs = values.get(name);
        if(vs == null) {
            vs = new ArrayList<DValueAst>(valueList.size());
            values.put(name, vs);
        }
        vs.addAll(valueList);
    }
    
    public void addAnnotation(String name, DAnnotationAst annotation) {
        ArrayList<DAnnotationAst> as = annotations.get(name);
        if(as == null) {
            as = new ArrayList<DAnnotationAst>(2);
            annotations.put(name, as);
        }
        as.add(annotation);
    }
    
    public void addAnnotations(String name, ArrayList<DAnnotationAst> annotationList) {
        ArrayList<DAnnotationAst> as = annotations.get(name);
        if(as == null) {
            as = new ArrayList<DAnnotationAst>(annotationList.size());
            annotations.put(name, as);
        }
        as.addAll(annotationList);
    }
    
    public Collection<String> getValueNames() {
        return values.keySet();
    }

    public ArrayList<DValueAst> getDefinition(String name) {
        return values.get(name);
    }

    public ArrayList<DAnnotationAst> getAnnotations(String name) {
        return annotations.get(name);
    }

    public void addFrom(ValueRepository repo, String oldName, String newName) {
        addDefinitions(newName, repo.getDefinition(oldName));
        
        ArrayList<DAnnotationAst> as = repo.getAnnotations(oldName);
        if(as != null)
            addAnnotations(newName, as);
    }

    public long getLocation(String name) {
        return locations.get(name);
    }
}
