package org.simantics.scl.compiler.internal.parsing.declarations;

import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;



public class DModuleHeader extends DeclarationAst {
    public final FieldAssignment[] fields;
    
    public DModuleHeader(FieldAssignment[] fields) {
        this.fields = fields;
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("module {");
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        boolean first = true;
        for(FieldAssignment field : fields) {
            if(first)
                first = false;
            else
                b.append(',');
            b.append('\n');
            for(int i=0;i<=indentation;++i) b.append("    ");
            b.append(field.name);
            b.append(" = ");
            field.value.accept(visitor);
        }
        b.append('\n');
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append('}');
    }
}
