package org.simantics.scl.compiler.internal.header;

import org.simantics.scl.compiler.elaboration.expressions.annotations.AnnotationUtils;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.parsing.declarations.DModuleHeader;

public class ModuleHeader {
    public String classLoader;
    public long classLoaderLocation;
    
    private void read(ErrorLog errorLog, DModuleHeader header) {
        for(FieldAssignment assignment : header.fields)
            switch(assignment.name) {
            case "bundle":
                if(assignment.value == null)
                    errorLog.log(assignment.location, "Property classLoader needs to be given a string value.");
                else {
                    classLoader = AnnotationUtils.extractString(assignment.value);
                    if(classLoader == null)
                        errorLog.log(assignment.value.location, "Expected bundle name here.");
                    else 
                        classLoaderLocation = assignment.location;
                }
                break;
            default:
                errorLog.logWarning(assignment.location, "Unknown module header field was skipped.");
            }
    }
    
    public static ModuleHeader process(ErrorLog errorLog, DModuleHeader header) {
        if(header == null)
            return null;
        ModuleHeader result = new ModuleHeader();
        result.read(errorLog, header);
        return result;
    }
}
