package org.simantics.scl.compiler.internal.elaboration.matching;


import java.util.Arrays;

import org.simantics.scl.compiler.elaboration.expressions.Expression;

public class Row {
    Expression[] patterns;
    Expression value;
    
    public Row(Expression[] patterns, Expression value) {
        this.patterns = patterns;
        this.value = value;
    }
    
    public Row replace(int columnToReplace, Expression[] substitution) {
        Expression[] newPatterns = new Expression[patterns.length-1+substitution.length];
        int j=0;
        for(int i=0;i<columnToReplace;++i)
            newPatterns[j++] = patterns[i];
        for(int i=0;i<substitution.length;++i)
            newPatterns[j++] = substitution[i];
        for(int i=columnToReplace+1;i<patterns.length;++i)
            newPatterns[j++] = patterns[i];
        return new Row(newPatterns, value);
    }
    
    @Override
    public String toString() {
        return Arrays.toString(patterns) + " -> " + value;
    }
}
