package org.simantics.scl.compiler.internal.codegen.writer;

import java.util.Map;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaStaticField;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.internal.codegen.ssa.StaticField;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.tuple.Tuple2;

import gnu.trove.map.hash.THashMap;

public class ModuleWriter {
    
    SSAModule module;
    
    String moduleClassName;
    THashMap<Tuple2, JavaStaticField> externalConstantMap = 
    		new THashMap<Tuple2, JavaStaticField>();
    int externalConstantId = 0;
    
    public ModuleWriter(String moduleClassName) {
        this.module = new SSAModule();
        this.moduleClassName = moduleClassName;
    }

    public CodeWriter createFunction(SCLConstant constant, TVar[] typeParameters,
            Type effect, Type returnType, Type[] parameterTypes) {
        Name name = constant.getName();
        SSAFunction function = new SSAFunction(typeParameters, effect, returnType);
        SSABlock block = new SSABlock(parameterTypes);
        function.addBlock(block);
        function.setTarget(constant);
        constant.setDefinition(function);
        module.put(name, constant);
        return new CodeWriter(this, block);
    }
    
    @Override
    public String toString() {
        return module.toString();
    }

    public SSAModule getModule() {
        return module;
    }

	public Constant getExternalConstant(Object value, Type type) {
		Tuple2 tuple = new Tuple2(value, type);
		if(externalConstantMap.contains(tuple))
			return externalConstantMap.get(tuple);
		else {		
			++externalConstantId;
			String name = "externalConstant" + externalConstantId;
			JavaStaticField constant = new JavaStaticField(moduleClassName, name, type, -1);
			externalConstantMap.put(tuple, constant);
			module.addStaticField(new StaticField(name, type));
			return constant;
		}
	}

	public ExternalConstant[] getExternalConstants() {
	    ExternalConstant[] result = new ExternalConstant[externalConstantMap.size()];
		int i=0;
		for(Map.Entry<Tuple2, JavaStaticField> entry : externalConstantMap.entrySet()) {
			result[i++] = new ExternalConstant(entry.getValue().getFieldName(), entry.getKey().c0);
		}
		return result;
	}
    
}
