package org.simantics.scl.compiler.errors;

import java.io.PrintWriter;
import java.io.StringWriter;

public class CompilationError implements Comparable<CompilationError> {
    
    public static final CompilationError[] EMPTY_ARRAY = new CompilationError[0];
    
    public final long location;
    public final String description;
    public final ErrorSeverity severity;
    
    public CompilationError(long location, String description, ErrorSeverity severity) {
        if(description == null)
            throw new NullPointerException();
        this.location = location;
        this.description = description;
        this.severity = severity;
    }
    
    public CompilationError(long location, String description) {
    	this(location, description, ErrorSeverity.ERROR);
    }		
    
    public CompilationError(long location, Exception exception) {
        this(location, exceptionToString(exception));
    }
    
    public CompilationError(String description) {
        this(Locations.NO_LOCATION, description);
    }
    
    public CompilationError(Exception exception) {
        this(Locations.NO_LOCATION, exception);
    }
    
    private static String exceptionToString(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }
   
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((description == null) ? 0 : description.hashCode());
        result = prime * result + (int) (location ^ (location >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CompilationError other = (CompilationError) obj;
        if (description == null) {
            if (other.description != null)
                return false;
        } else if (!description.equals(other.description))
            return false;
        if (location != other.location)
            return false;
        return true;
    }

    @Override
    public int compareTo(CompilationError o) {
        if(location < o.location)
            return -1;
        if(location > o.location)
            return 1;
        return description.compareTo(o.description);
    }
    
    @Override
    public String toString() {
        return new StringBuilder().append("CompilationError: \"").append(description).append("\" at location ").append(location).toString();
    }
}
