package org.simantics.scl.compiler.environment;

import java.util.Collection;

import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.module.Module;

import gnu.trove.map.hash.THashMap;

public class ConcreteEnvironment extends AbstractEnvironment {

    private final THashMap<String, Module> moduleMap;
    private final Namespace localNamespace;
    
    public ConcreteEnvironment(THashMap<String, Module> moduleMap,
            Namespace localNamespace) {
        this.moduleMap = moduleMap;
        this.localNamespace = localNamespace;
    }

    @Override
    public Namespace getLocalNamespace() {
        return localNamespace;
    }

    @Override
    protected Module getModule(String name) {
        return moduleMap.get(name);
    }
    
    @Override
    protected Collection<Module> getModules() {
        return moduleMap.values();
    }

    @Override
    public void collectRules(Collection<TransformationRule> rules) {
        for(Module module : moduleMap.values())
            module.getRules();
    }

}
